import numpy as np
from realCh import *

config = {
    'eqs': {
        'firOn': True,
        'dfeOn': True,
        'firDfeOn': False,
        'viterbiOn': False,
        'fwdBwdOn': True,
        'fwdOn': False,
        'neqOn': False,
        'mod': 'pam4',
        'snrList': np.arange(30, 8, -2),
        'chSBR': [1.0,0.4,0.2,0.1],
        'eqSBR': [1.0,0.4,0.2,0.1],
        'plot': False,
        #'chSBR': sbr35dB,
        #'eqSBR': sbr35dB,
        'dataSize': 1e7,
        'noiseFlag': 1,
        # For FFE
        'firTapNumForFir': 8,
        # For DFE
        'dfeTapNumForDfe': None,
        # For FIR+DFE
        'firTapNumForFirDfe': 24,
        'dfeTapNumForFirDfe': None,
        'firMaxTapForFirDfe': 10,
        # For Viterbi
        'blockSizeList': [100],
        # For FwdBwd
        'fwdBwdLen': 12,
        'fwdBwdSnrOvrd': None,
        # For Fwd
        'FwdLen': 5,
        # For N-EQ
        'modelFileList': ['./results/isi12dB_TRAIN/nEQ_pam4_20dB_simp1_crossEntropy.pt'],
        'inSize': 12,
        'outSize': 1,
    },

    'prune': {
        'modelFile': './results/isi0_TRAIN/nEQ_pam4_20dB_simp1_crossEntropy.pt',
        'pruneRatio': 0.1,
        'numIterPrune': 20,
        'numFineTune': 20,
        'mod': 'pam4',
        'chSBR': sbr21dB,
        'batchSize': 8192,
        'dataSizeTrain': 1e6,
        'dataSizeValid': 1e6,
        'snrValid': 22,
        'snrTrain': 22,
        'noiseFlag': 1,
        'inSize': 12,
        'outSize': 1,
        'lossFn': 'crossEntropy',
        'lr': 1e-3,

        
    },

    'train': {
        'selTrainDataList': [1],					# 0: FwdBwd data // 1: True data
        # crossEntropy // manualCrossEntropy // mse
        'lossFnList': ['crossEntropy'],
        'useFwdBwdNeuralEq': True, 				# False : using FC neural EQ
        'mod': 'pam4',
        'snrTrainList': np.arange(20, 19, -2),
        'chSBR': [1.0,0.4,0.2,0.1],
        'eqSBR': [1.0,0.4,0.2,0.1],
        'dataSizeTrain': 1e6,
        'dataSizeValid': 1e6,
        'dataSizeTest': 1e6,
        'snrValid': 20,
        'snrTest': 20,
        'onTheFly': True,
        'noiseFlag': 1,
        'plotLoss': True,
		'trainSnrVariation': False,

        'delayOffset': None,
        'usePrunedNeuralEq': False,
        'prunedModelFile': './results/isi0_1_PRUNE/nEq_pam4_prune6.pt',

        'forceTrainIn': False,
        'mismatchSNR': None,
        # Neq Params
        'inSize': 12,
        'outSize': 1,
        'N': 32,     # 32 is optimal
        #'inSize': 12,
        #'outSize': 1,
        #'N': 32,     # 32 is optimal
        'hiddenStage': 2,
        # Train Params
        'numEpoch': 2000,
        'batchSize': 8192,
        'lr': 1e-3,
        'weightDecay': 0,
        'evalFreq': 10,
    },

    'eval': {
        'modelFileList': [
                './results/isi0_TRAIN/nEQ_pam4_20dB_simp1_crossEntropy.pt',
                #'./results/isi26dB_4030_in32_TRAIN/nEQ_pam4_40dB_simp1_crossEntropy.pt',
                #'./results/isi26dB_4030_in32_TRAIN/nEQ_pam4_38dB_simp1_crossEntropy.pt',
                #'./results/isi26dB_4030_in32_TRAIN/nEQ_pam4_36dB_simp1_crossEntropy.pt',
                #'./results/isi26dB_4030_in32_TRAIN/nEQ_pam4_34dB_simp1_crossEntropy.pt',
                #'./results/isi26dB_4030_in32_TRAIN/nEQ_pam4_32dB_simp1_crossEntropy.pt',
                #'./results/isi21dB_delay_TRAIN/nEQ_pam4_20dB_simp1_crossEntropy.pt',
                #'./results/isi0_3020_TRAIN/nEQ_pam4_28dB_simp1_crossEntropy.pt',
                #'./results/isi0_3020_TRAIN/nEQ_pam4_26dB_simp1_crossEntropy.pt',
                #'./results/isi0_3020_TRAIN/nEQ_pam4_24dB_simp1_crossEntropy.pt',
                #'./results/isi0_3020_TRAIN/nEQ_pam4_22dB_simp1_crossEntropy.pt',
                #'./results/isi0_2010_TRAIN/nEQ_pam4_20dB_simp1_crossEntropy.pt',
                #'./results/isi0_2010_TRAIN/nEQ_pam4_18dB_simp1_crossEntropy.pt',
                #'./results/isi0_2010_TRAIN/nEQ_pam4_16dB_simp1_crossEntropy.pt',
                #'./results/isi0_2010_TRAIN/nEQ_pam4_14dB_simp1_crossEntropy.pt',
                #'./results/isi0_2010_TRAIN/nEQ_pam4_12dB_simp1_crossEntropy.pt',
                ],
        'mod': 'pam4',
        'chSBR': [1.0,0.4,0.2,0.1],
        'dataSizeTrain': 1e7,
        'dataSizeValid': 1e7,
        'dataSizeTest': 1e7,
        #'snrValid': 20,
        #'snrTrain': 20,
        'snrTestList': np.arange(30,8,-2),
        'noiseFlag': 1,
        'inSize': 12,
        'outSize': 1,

        # Fine tune params
        'finetune': False,
        'lossFn': 'crossEntropy',
        'numEpoch': 100,
        'batchSize': 8192,
        'lr': 1e-3,
        'weightDecay': 0,
        'evalFreq': 10,
    },

    'pruneAnalysis':{
        'modelFileList':[
                    './results/isi0_1_PRUNE/nEq_pam4_prune6.pt',
                    './results/isi0_2_PRUNE/nEq_pam4_prune6.pt',
                    './results/isi0_3_PRUNE/nEq_pam4_prune6.pt',
                    './results/isi0_4_PRUNE/nEq_pam4_prune6.pt',
                    './results/isi0_5_PRUNE/nEq_pam4_prune6.pt',
                    './results/isi0_6_PRUNE/nEq_pam4_prune6.pt',
                    './results/isi0_7_PRUNE/nEq_pam4_prune6.pt',
                    './results/isi0_9_PRUNE/nEq_pam4_prune6.pt',
        ],
        'threshold': 0
    }


}
